<?php
/**
* @version		2.0
* @package		Responsive Slide Show
* @copyright    Copyright (C) 2012 Crosstec GmbH & Co. KG - Until Skitter Slideshow version 3.1 Qubesys Technologies. All rights reserved.
* @license		GNU/GPL
*/
defined('_JEXEC') or die('Restricted access');

if(!function_exists('ct_Hex2RGB')){
    function ct_Hex2RGB($color){
        $color = str_replace('#', '', $color);
        if (strlen($color) != 6){ return array(0,0,0); }
        $rgb = array();
        for ($x=0;$x<3;$x++){
            $rgb[$x] = hexdec(substr($color,(2*$x),2));
        }
        return $rgb;
    }
}

$base_url=JURI::base();
$doc = JFactory::getDocument();
$doc->addStyleSheet('modules/mod_responsive_slideshow/tmpl/css/flexslider.css');
if($load1==1)
{
    $doc->addScript($base_url.'modules/mod_responsive_slideshow/tmpl/js/jquery.min.js');
}

?>
<script type="text/javascript" src="<?php echo $base_url;?>modules/mod_responsive_slideshow/tmpl/js/jquery.flexslider-min.js"></script>

<?php
$flex_id = $params->get('moduleclass_sfx') ? 'flexslide-'.$params->get('moduleclass_sfx') : 'flexslide';

if($navigation==1) {
	$navigation="true";
} else {
	$navigation="false";
}

if($pagination==1) {
	$pagination="false";
} else {
	$pagination="true";
}

if($keyboard==1) {
	$keyboard="false";
} else {
	$keyboard="true";
}

if($hover_pause==1) {
	$hover_pause="false";
} else {
	$hover_pause="true";
}

if($label==1) {
	$label="true";
} else {
	$label="false";
}

if($random_slides==1) {
	$random_slides="true";
} else {
	$random_slides="false";
}

JFactory::getDocument()->addScriptDeclaration('
  var flexy = jQuery.noConflict();	
  flexy(window).load(function() {
    flexy("#'.$flex_id.'").flexslider({
        animation: "'.$animation.'",            //String: Select your animation type, "fade" or "slide"
        slideDirection: "horizontal",   		//String: Select the sliding direction, "horizontal" or "vertical"
        slideshow: true,                		//Boolean: Animate slider automatically
        slideshowSpeed: '.$interval.',          //Integer: Set the speed of the slideshow cycling, in milliseconds
        animationDuration: 600,         		//Integer: Set the speed of animations, in milliseconds
        directionNav: '.$navigation.',          //Boolean: Create navigation for previous/next navigation? (true/false)
        controlNav: '.$pagination.',            //Boolean: Create navigation for paging control of each clide? Note: Leave true for manualControls usage
        keyboardNav: '.$keyboard.',             //Boolean: Allow slider navigating via keyboard left/right keys
        mousewheel: false,              		//Boolean: Allow slider navigating via mousewheel
        prevText: "Previous",           		//String: Set the text for the "previous" directionNav item
        nextText: "Next",               		//String: Set the text for the "next" directionNav item
        pausePlay: false,              			//Boolean: Create pause/play dynamic element
        pauseText: "Pause",             		//String: Set the text for the "pause" pausePlay item
        playText: "Play",               		//String: Set the text for the "play" pausePlay item
        randomize: '.$random_slides.',               		//Boolean: Randomize slide order
        slideToStart: 0,                		//Integer: The slide that the slider should start on. Array notation (0 = first slide)
        animationLoop: true,            		//Boolean: Should the animation loop? If false, directionNav will received "disable" classes at either end
        pauseOnAction: true,            		//Boolean: Pause the slideshow when interacting with control elements, highly recommended.
        pauseOnHover: '.$hover_pause.',            //Boolean: Pause the slideshow when hovering over slider, then resume when no longer hovering
        controlsContainer: ".flex-container'.$flex_id.'"
    });
  });
  ');
?>
        
<div class="flex-container<?php echo $flex_id;?>">
  <div id="<?php echo $flex_id;?>" class="flexslider">
    <ul class="slides">
      <?php
			$image1 = explode(",",$image);
                        $regex = '#<hr(.*)class="system-pagebreak"(.*)\/>#iU';
                        $imglabel1 = preg_split($regex, $imglabel);
			for ($i=0;$i<count($image1);$i++) {
			      		?>
        <li>
            <img src="<?php echo $image1[$i];?>">
            <?php
            if(isset($imglabel1[$i]) && trim($imglabel1[$i])!=""){
            ?>
            <div class="flex-caption">
                    <div class="flex-caption-text">
			<?php echo $imglabel1[$i];?>
                    </div>
            </div>
            <?php
            }
            ?>
        </li>
			<?php
			}
			?>
    </ul>
  </div>
</div>

